import { createRouter, createWebHashHistory } from 'vue-router'
import login from '@/views/login/index.vue'
import layout from '@/layout/index.vue'

const router = createRouter({
  history: createWebHashHistory(),
  routes: [
    {
      path: '/',
      name: 'login',
      component: login
    },
    {
      path: '/center',
      component: layout,
      redirect: '/tenant',
      children: [
        {
          path: '/tenant',
          component: () => import('@/views/tenant/index.vue')
        },
        {
          path: '/logs',
          component: () => import('@/views/logs/index.vue')
        },
        {
          path: '/imageManagement',
          component: () => import('@/views/imageManagement/index.vue')
        },
        {
          path: '/jarManagement',
          component: () => import('@/views/jarManagement/index.vue')
        },
        {
          path: '/execute',
          component: () => import('@/views/execute/index.vue')
        },
        {
          path: '/syncConfig',
          component: () => import('@/views/syncConfig/index.vue')
        },
        {
          path: '/systemBackup',
          component: () => import('@/views/systemBackup/index.vue')
        }
      ]
    }
  ]
})

export default router
