import { defineStore } from 'pinia'
import piniaPersistConfig from '../helper/piniaPersist'
import { getTenantList } from '@/api'

export const useTenantStore = defineStore('tenant', {
  // 相当于data
  state: () => {
    return {
      tenantId: '',
      tenantList: [] as any
    }
  },
  // 相当于计算属性
  getters: {
    getTenantList: (state) => state.tenantList,
    getTenantId: (state) => state.tenantId,
    getTenantName: (state) =>
      state.tenantList.find((item: any) => item.tenantId === state.tenantId)?.tenantName
  },
  actions: {
    async initTenantList() {
      const res: any = await getTenantList()
      if (res.code === 200) {
        this.tenantList = res.data
        this.tenantId = res.data?.length ? res.data[0].tenantId : ''
      }
    },
    setTenantId(tenantId: any) {
      this.tenantId = tenantId
    }
  },
  persist: piniaPersistConfig('tenant')
})
