interface IUrl {
    [key: string]: string

}

interface IModules {
    [index: string]: IUrl
}
/** @type {模块：{菜单键值：菜单地址}} */
const menuConfig: IModules = {
    base: {
        login: 'oauth2/login',
        auth: 'oauth2'
    }
}

/** @type {http请求地址} */
const urlConfig: IUrl = {
    importUrl: 'import',
    test: 'test'
}

/** @type {http请求地址} */
const userUrlConfig: IUrl = {
    //获取验证码
    imageCode: "auth/getCaptcha",
    //登录
    login: "auth/login",
    //获取当前用户菜单
    getMenuList: "user/getMenuList",
    //获取当前用户信息
    getUserInfo: "user/getUserInfo",
    //注册
    register: "user/register",
    //添加用户
    addUser: 'message/add',
    //获取用户
    getUser: 'message/list',
    //编辑用户
    editUser: 'message/edit',
    //删除用户
    deleteUser: 'message/delete',
}

/** @type {http请求地址} */
const authUrlConfig: IUrl = {
    //查询账号角色
    findRoleByUser: 'userAccount/findRoleByUser',
    //添加菜单
    addMenu: "permission/add",
    //删除菜单
    deleteMenu: "permission/delete",
    //编辑菜单
    editMenu: "permission/edit",
    //获取菜单路由
    getMenuTree: 'permission/getMenuTree',
    //获取权限树
    getPermissionTree: "permission/list",
    //查询角色授权
    queryRoleMenu: "permission/queryRolePermission",
    //查询所有权限树
    queryTreeList: "permission/queryTreeList",
    //保存角色授权
    saveRolePermission: 'permission/saveRolePermission',
    //角色分页查询
    getRoleList: 'role/list',
    //添加角色
    addRole: 'role/add',
    //删除角色
    deleteRole: 'role/delete',
    //编辑角色
    editRole: 'role/edit',
    //获取全部角色
    getAllRole: 'role/queryAll',
}

/** @type {http请求地址} */
const tableCreatorUrlConfig: IUrl = {
    //创建表
    createTable: 'starbos_codegenerator/generatetable/create',
    //查询表
    queryTable: 'starbos_codegenerator/generatetable/list',
    //获取文件类型
    getFiledType: 'starbos_codegenerator/generatetable/getFiledType',
}

const projectUrlConfig: IUrl = {
    //创建项目
    addProject: 'starbos_project/project/add',
    //删除项目
    deleteProject: 'starbos_project/project/delete',
    //编辑项目
    editProject: 'starbos_project/project/edit',
    //分页查询项目
    projectList: 'starbos_project/project/list'
}


export { menuConfig, urlConfig, userUrlConfig, authUrlConfig, tableCreatorUrlConfig, projectUrlConfig };