import { request } from "../../config";

export function getStructureList(formId?: string, pageNo?: number, pageSize?: number) {
  return request({
    url: "/api/form/table/structure/list",
    method: "get",
    params: { formId, pageNo, pageSize }
  });
}

export function getStructureData(formId: string, pageNo?: number, pageSize?: number) {
  return request({
    url: "/api/form/table/structure/data",
    method: "get",
    params: { formId, pageNo, pageSize }
  });
}

export function saveStructure(data: any, id?: number) {
  return request({
    url: "/api/form/table/structure/create",
    method: "post",
    data: { data, id }
  });
}

export function deleteStructure(id: number, dbTableName: string) {
  return request({
    url: "/api/form/table/structure/delete",
    method: "delete",
    params: { id, dbTableName }
  });
}

export function deleteStructureData(id: number, dbTableName: string) {
  return request({
    url: "/api/form/table/structure/data/delete",
    method: "delete",
    params: { id, dbTableName }
  });
}