import { objectPick } from "@vueuse/shared";

export function isValidKey(key: string | number | symbol, object: object): key is keyof typeof object {
  return key in object;
}


/**
 * 复制对象到新对象,src复制到obj
 * @param obj 目标对象
 * @param src 源对象
 * @param key 源对象属性
 */
export function CopyData<T, K extends keyof T>(obj: T, src: T, key: K) {
  obj[key] = src[key]
}




/**
 * 获取对象属性值
 * @param obj 对象
 * @param key 对象中的属性
 * @returns 返回对象属性值
 */
export function getProperty<T, K extends keyof T>(obj: T, key: K) {
  return obj[key]
}



/**
 * 清空表单
 * @param fromRef  表单的ref属性
 * @param obj      表单绑定的model
 */
export function resetForm(fromRef: any, obj: any) {
  //清空数据
  Object.keys(obj).forEach(key => {
    obj[key] = ''
  })
  //清除表单的验证
  if (fromRef) {
    fromRef.resetFields();
    fromRef.clearValidate();
  }
}