import { request } from '../config'

export const getMapList = (params: any) => {
    return request({
        url: '/api/kingdee/field/mapping/list',
        method: 'get',
        params
    })
}

export const createMap = (data: any) => {
    return request({
        url: '/api/kingdee/field/mapping/create',
        method: 'post',
        data
    })
}

export const updateMap = (data: any) => {
    return request({
        url: '/api/kingdee/field/mapping/update',
        method: 'put',
        data
    })
}

export const deleteMap = (id: number, kingdeeCommonConfigId: number) => {
    return request({
        url: '/api/kingdee/field/mapping/delete',
        method: 'delete',
        params: { id, kingdeeCommonConfigId }
    })
}