module.exports = {
  root: true,
  parserOptions: {
    // 对Babel解析器的包装使其与 ESLint 兼容。
    //   parser: 'babel-eslint',
    // 代码是 ECMAScript 模块
    sourceType: "module",
  },
  parser: "vue-eslint-parser",
  env: {
    browser: true,
    node: true,
    es6: true,
  },
  extends: [
    // https://github.com/vuejs/eslint-plugin-vue
    "plugin:vue/vue3-essential",
    "plugin:vue/vue3-strongly-recommended",
    "plugin:vue/vue3-recommended",
  ],
  rules: {
    "no-console": "off",
    "comma-dangle": [2, "never"], //禁用使用拖尾逗号
    "vue/html-self-closing": [
      "error",
      {
        html: {
          void: "never",
          normal: "always",
          component: "always",
        },
        "vue/multi-word-component-names": [
          "off",
          {
            ignores: [],
          },
        ], //允许组件单词
      },
    ],
  },
};
