import { request } from '../config'

const API_COMMON = '/'

export function getTableList(
  name: string,
  data?: any
) {
  return request({
    url: API_COMMON + name,
    method: 'get',
    data
  })
}

export function tableSave(
  name: string,
  method: 'post' | 'put',
  data?: any
) {
  return request({
    url: API_COMMON + name,
    method: method,
    data
  })
}

export function tableDelete(
  name: string,
  params?: any
) {
  return request({
    url: API_COMMON + name,
    method: 'delete',
    params
  })
}
