import { request } from "../../config";

// 金蝶通用配置列表
export function getCommonConfig(
  platformProductRelationId: number,
  pageNo?: number,
  pageSize?: number,
  name?: string,
  operation?: number
) {
  return request({
    url: "/api/kingdee/common/config/list",
    method: "get",
    params: { platformProductRelationId, pageNo, pageSize, name, operation },
  });
}

// 金蝶通用配置创建
export function addCommonConfig(data: any) {
  return request({
    url: "/api/kingdee/common/config/create",
    method: "post",
    data,
  });
}

export function manualExcute(data: any)
{
  return request({
    url: "/api/manual/synchronizationByParam",
    method: "post",
    data,
  });

}

// 金蝶通用配置更新
export function putCommonConfig(data: any) {
  return request({
    url: "/api/kingdee/common/config/update",
    method: "put",
    data,
  });
}
// 金蝶通用配置删除
export function deleteCommonConfig(id: number) {
  return request({
    url: "/api/kingdee/common/config/delete",
    method: "delete",
    params: { id },
  });
}
