import { TableConfigData } from "@/table/type";

const menuConfigData: TableConfigData = {
  title: "菜单",
  tableTitle: [
    {
      label: "菜单名称",
      prop: "title",
      type: "input",
    },
    {
      label: "菜单类型",
      prop: "type",
      type: "radio",
    },
    {
      label: "上级菜单",
      prop: "parentId",
      type: "select",
      selectProp: {
        value: "id",
        label: "title",
      },
    },
    {
      label: "icon",
      prop: "icon",
      type: "input",
    },
    {
      label: "组件",
      prop: "component",
      type: "input",
    },
    {
      label: "路径",
      prop: "path",
      type: "input",
    },
    {
      label: "排序",
      prop: "sortNo",
      type: "input",
      inputType: "number",
    },
  ],
  drawerformData: {
    id: "",
    type: 0,
    title: "",
    component: "",
    path: "",
    sortNo: 0,
    apiKey: "",
    parentId: "",
    icon: "",
    is_show: true,
  },
  rules: {
    title: [{ required: true, message: "请输入菜单名称", trigger: "blur" }],
    component: [{ required: true, message: "请输入菜单组件", trigger: "blur" }],
    path: [{ required: true, message: "请输入菜单路径", trigger: "blur" }],
    apiKey: [{ required: true, message: "请输入接口路径", trigger: "blur" }],
  },
  btnObj: {
    width: "200",
    isAdd: true,
    isDelete: true,
  },
  apiKey: "permission",
  tableApi: "/getMenuTree",
  dataKey: "",
};

export { menuConfigData };
