import { ref, onMounted } from "vue";
import {
  getkingdeeLog,
  getThirdPartyLog,
  getProductLog
} from "@/services/api/systemApi/log/logApi";

export const usekingdeeLogTableList = () => {
  const tableList = ref([]);
  const total = ref(0);
  // 当前页数
  const currentPage = ref(1);
  // 每页条数
  const pageSize = ref(10);
  const loading = ref(true);
  onMounted(async () => {
    const res = await getkingdeeLog(currentPage.value, pageSize.value);
    tableList.value = res.data.records;
    total.value = res.data.total;
    loading.value = false;
  });
  return {
    tableList,
    total,
    loading,
    currentPage,
    pageSize,
  };
};

export const useThirdPartyTableList = () => {
  const tableList = ref([]);
  const total = ref(0);
  // 当前页数
  const currentPage = ref(1);
  // 每页条数
  const pageSize = ref(10);
  const loading = ref(true);
  onMounted(async () => {
    const res = await getThirdPartyLog(currentPage.value, pageSize.value);
    console.log("数据", res);
    tableList.value = res.data.records;
    total.value = res.data.total;
    loading.value = false;
  });
  return {
    tableList,
    total,
    loading,
    currentPage,
    pageSize,
  };
};

export const useproductLogTableList = () => {
  const tableList = ref([]);
  const total = ref(0);
  // 当前页数
  const currentPage = ref(1);
  // 每页条数
  const pageSize = ref(10);
  const loading = ref(true);
  const platformProductRelationId: any = null
  onMounted(async () => {
    const res = await getProductLog(platformProductRelationId, currentPage.value, pageSize.value);
    tableList.value = res.data.records;
    total.value = res.data.total;
    loading.value = false;
  });
  return {
    tableList,
    total,
    loading,
    currentPage,
    pageSize,
  };
};
