import { createRouter, createWebHashHistory, RouteRecordRaw } from "vue-router";
import Layout from "@/layout/index.vue";
const routes: Array<RouteRecordRaw> = [
  {
    path: "/",
    component: Layout,
    redirect: "/dashboard",
    children: [
      {
        path: "/dashboard",
        component: () => import("@/views/dashboard/index.vue"),
        name: "dashboard",
        meta: {
          title: "首页",
          icon: "#icondashboard",
        },
      },
    ],
  },
  {
    path: '/manage',
    component: Layout,
    children: [
      {
        path: '/manage/fieldConfiguration',
        name: 'configMap',
        component: () => import("@/views/manage/fieldConfiguration.vue"),
      },
    ]
  },
  {
    path: "/login",
    name: "login",
    component: () => import("@/views/login/login.vue"),
  },
  {
    path: "/404",
    name: "404",
    component: () => import("@/views/exception/404.vue"),
  },
  // {
  //     path: '/:catchAll(.*)',
  //     redirect: '/404'
  // }
];

export const asyncRoutes: Array<RouteRecordRaw> = [];

const router = createRouter({
  history: createWebHashHistory(),
  // routes = routes:routes
  routes,
});

export function addRoutes(routes: any) {
  router.addRoute(routes);
}

export default router;
