import { request } from '../config'

// 字典项列表
export const getDictItemList = (params: any) => {
    return request({
        url: '/api/dict/item/list',
        method: 'get',
        params
    })
}

// 平台产品关系列表
export const getPlatformProductList = () => {
    return request({
        url: '/api/platform/product/relation/list',
        method: 'get'
    })
}

// 平台产品关系创建
export const createPlatformProduct = (data: any) => {
    return request({
        url: '/api/platform/product/relation/create',
        method: 'post',
        data
    })
}

export const deletePlatformProduct = (params: any) => {
    return request({
        url: '/api/platform/product/relation/delete',
        method: 'delete',
        params
    })
}

export const getCommonParam = (code: string) => {
    return request({
        url: '/api/product/init/common/param',
        method: 'get',
        params: { code }
    })
}

export const postCommonParam = (data: any) => {
    return request({
        url: '/api/product/init/common/param/create',
        method: 'post',
        data
    })
}

// 校验
export const checkCommon = (data: any) => {
    return request({
        url: '/api/product/init/common/param/check',
        method: 'post',
        data
    })
}


export const getCommonParamData = (code: any) => {
    return request({
        url: '/api/product/init/common/param/data',
        method: 'get',
        params: { code }
    })
}

// 启用
export const productEnable = (data: any) => {
    return request({
        url: '/api/product/quartz/job/start',
        method: 'post',
        data
    })
}

// 停用
export const productDeactivate = (code: any) => {
    return request({
        url: '/api/product/quartz/job/turn/off',
        method: 'post',
        data: { code }
    })
}

// 同步状态
export const productStatus = (code: any) => {
    return request({
        url: '/api/product/quartz/job/data',
        method: 'get',
        params: { code }
    })
}

