import { request } from "../../config";

// 查询金蝶日志
export function getkingdeeLog(
  pageNo?: number,
  pageSize?: number,
  dateFrom?: string,
  dateTo?: string,
  name?: string,
  flag?: any,
  costTimeFrom?: number,
  costTimeTo?: number,
  queueId?: string
) {
  return request({
    url: "/api/kingdee/log/list",
    method: "get",
    params: {
      pageNo,
      pageSize,
      dateFrom,
      dateTo,
      name,
      flag,
      costTimeFrom,
      costTimeTo,
      queueId,
    },
  });
}

// 查询第三方日志
export function getThirdPartyLog(
  pageNo?: number,
  pageSize?: number,
  dateFrom?: string,
  dateTo?: string,
  name?: string,
  flag?: any,
  queueId?: string
) {
  return request({
    url: "/api/third/party/log/list",
    method: "get",
    params: { pageNo, pageSize, dateFrom, dateTo, name, flag, queueId },
  });
}

// 产品日志
export function getProductLog(
  platformProductRelationId: number,
  pageNo?: number,
  pageSize?: number,
  dateFrom?: string,
  dateTo?: string,
  name?: string,
  flag?: any,
  costTimeFrom?: number,
  costTimeTo?: number,
  queueId?: string,
) {
  return request({
    url: "/api/product/log/list",
    method: "get",
    params: {
      platformProductRelationId,
      pageNo,
      pageSize,
      dateFrom,
      dateTo,
      name,
      flag,
      costTimeFrom,
      costTimeTo,
      queueId
    },
  });
}