import { defineConfig } from "vitepress";

// https://vitepress.dev/reference/site-config
export default defineConfig({
  title: "深圳市灵清科技有限公司",
  description:
    "致力于软件开发、金蝶二开、网站建设、小程序开发、微信开发、企业信息化建设",
  themeConfig: {
    nav: [
      { text: "指南", link: "/guide/" },
      { text: "管理中心", link: "/management-center/" },
      { text: "集成平台", link: "/integration-platform/" },
      { text: "低代码", link: "/low-code/" },
    ],

    sidebar: {
      "/guide/": [
        {
          text: "简介",
          items: [{ text: "什么是集成管理平台？", link: "/guide/" }],
          collapsed: false,
        },
      ],
      "/management-center/": [
        {
          text: "管理中心",
          items: [
            {
              text: "首页",
              link: "/management-center/",
            },
            {
              text: "安装工具",
              link: "/management-center/install-tools/",
            },
            {
              text: "租户管理",
              link: "/management-center/tenant/",
            },
            {
              text: "容器管理",
              link: "/management-center/log/",
            },
            {
              text: "日志管理",
              link: "/management-center/container/",
            },
            {
              text: "备份还原",
              link: "/management-center/backup-restore/",
            },
          ],
          collapsed: false,
        },
      ],
      "/integration-platform/": [
        {
          text: "集成平台",
          items: [{ text: "首页", link: "/integration-platform/" }],
        },
      ],
      "/low-code/": [
        {
          text: "低代码",
          items: [
            {
              items: [{ text: "首页", link: "/low-code/" }],
            },
          ],
        },
      ],
    },
    // 右上角导航图标
    socialLinks: [
      {
        icon: {
          svg: '<svg t="1726729973569" class="icon" viewBox="0 0 1536 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="8288" width="200" height="200"><path d="M1425.066667 149.58933331H110.933333A110.933333 110.933333 0 0 0 0 260.18133331v723.626667a110.933333 110.933333 0 0 0 110.933333 110.933333h1314.389334c61.269333 0 110.933333-49.749333 110.677333-110.677333V260.18133331A110.933333 110.933333 0 0 0 1425.066667 149.58933331z" fill="#FF7232" p-id="8289"></path><path d="M664.746667 873.13066631V585.21600031L517.12 769.70666631 369.664 585.21600031v288l-148.053333-67.157334V371.11466631h147.626666l147.626667 184.576 147.541333-184.576h147.626667v565.76z" fill="#FFFFFF" p-id="8290"></path><path d="M1024 149.33333331h426.666667a85.333333 85.333333 0 0 1 85.333333 85.333333v768a85.333333 85.333333 0 0 1-85.333333 85.333334h-426.666667V149.33333331z" fill="#000000" p-id="8291"></path><path d="M1256.96 880.64000031l-170.666667-216.490667h113.749334V453.97333331h113.749333v210.176h113.834667z" fill="#FFFFFF" p-id="8292"></path></svg>',
        },
        link: "https://markdown.com.cn/basic-syntax/",
      },
      {
        icon: {
          svg: '<svg t="1726729237203" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="4279" width="200" height="200"><path d="M932.317184 567.76704L885.10464 422.46144l-93.57312-287.997952c-4.8128-14.81728-25.776128-14.81728-30.590976 0L667.36128 422.459392H356.62848L263.051264 134.46144c-4.8128-14.81728-25.776128-14.81728-30.593024 0l-93.57312 287.997952-47.210496 145.309696a32.165888 32.165888 0 0 0 11.68384 35.96288l408.6272 296.890368L920.61696 603.734016c11.272192-8.192 15.990784-22.71232 11.68384-35.964928" fill="#FC6D26" p-id="4280"></path><path d="M512.002048 900.62848l155.365376-478.171136H356.634624z" fill="#E24329" p-id="4281"></path><path d="M512.004096 900.62848L356.63872 422.47168H138.901504z" fill="#FC6D26" p-id="4282"></path><path d="M138.891264 422.465536l-47.214592 145.309696a32.16384 32.16384 0 0 0 11.685888 35.96288L511.991808 900.62848z" fill="#FCA326" p-id="4283"></path><path d="M138.893312 422.459392h217.737216L263.053312 134.46144c-4.8128-14.819328-25.778176-14.819328-30.590976 0z" fill="#E24329" p-id="4284"></path><path d="M512.002048 900.62848l155.365376-478.154752H885.10464z" fill="#FC6D26" p-id="4285"></path><path d="M885.11488 422.465536l47.214592 145.309696a32.16384 32.16384 0 0 1-11.685888 35.96288L512.014336 900.62848z" fill="#FCA326" p-id="4286"></path><path d="M885.096448 422.459392H667.36128l93.577216-287.997952c4.814848-14.819328 25.778176-14.819328 30.590976 0z" fill="#E24329" p-id="4287"></path></svg>',
        },
        link: "http://code.lingqingkeji.com/",
      },
      {
        icon: {
          svg: '<svg t="1726729529247" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="5332" width="200" height="200"><path d="M85.333333 0h853.333334c46.933333 0 85.333333 38.4 85.333333 85.333333v853.333334c0 46.933333-38.4 85.333333-85.333333 85.333333H85.333333c-46.933333 0-85.333333-38.4-85.333333-85.333333V85.333333c0-46.933333 38.4-85.333333 85.333333-85.333333z" fill="#1E2221" p-id="5333"></path><path d="M524.8 155.733333v93.866667l206.933333 121.6 83.2-49.066667z" fill="#579A78" p-id="5334"></path><path d="M744.533333 392.533333v253.866667L512 780.8l-232.533333-134.4V377.6l219.733333-128V155.733333L196.266667 330.666667v362.666666L512 876.8l315.733333-183.466667V345.6z" fill="#FFFFFF" p-id="5335"></path><path d="M473.6 413.866667h46.933333v12.8l2.133334-4.266667c12.8-12.8 53.333333-12.8 72.533333-12.8h2.133333v46.933333c-12.8 0-46.933333 0-61.866666 6.4-10.666667 6.4-12.8 19.2-12.8 36.266667V618.666667h-51.2v-204.8z" fill="#579A78" p-id="5336"></path></svg>',
        },
        link: "http://assembly.lingqingkeji.com/",
      },
    ],
  },
});
