# 备份还原

## 功能介绍

此功能的目的是为了降低产品迭代风险，对产品镜像进行备份还原的操作，当迭代的环境出现问题的时候，可以及时下载备份镜像进行镜像还原。

也可以创建新环境时，直接还原系统备份即可，可以快速安装与之前一样的环境。

![](image/image_TNuvEGLvYc.png)

### 注意：

请不要同时操作，等待某个功能操作进度条结束后再进行其他操作； 系统备份进行下载与还原功能时，禁止刷新页面，否则会导致操作失败，请耐心等待！

## 备份

介绍：备份当前环境镜像，注意每次备份后都会删除上传备份镜像。

备份存放地址：/root/back/租户名称/output.zip

操作：点击系统备份，确认备份系统，会出现备份进度，等待进度条完成即可。

![](image/image_PftzVdmBVR.png)

右上角出现已备份，说明已经备份完成。

![](image/image_EAW4jXSEKi.png)

## 下载

介绍：下载当前环境备份后的镜像。

操作：点击下载备份，确认下载系统备份，会出现下载进度，等待进度条完成即可。

![](image/image_iL4CBv9H16.png)

在浏览器下载记录中，会出现该备份镜像压缩包。

![](image/image_IOPspdAo0P.png)

## 还原

介绍：还原当前环境备份镜像。

**注意：如果环境已经部署，需要还原，请先清空当前环境 docker 的容器与镜像!**

![](image/image_3Q4h5Evo3P.png)

使用 docker ps 查看所有镜像

![](image/image__9IeA6ytVy.png)

使用 docker rm -f \$(docker ps -a -q) 删除所有镜像。

**注意：需要看清楚当前环境是否有其他无关本产品的镜像，如果有需谨慎删除，此命令是删除所有镜像，有用镜像你需要分开删除 docker rm -f xxx(CONTAINER ID)。**

![](image/image_DP0RVYI6R6.png)

查看一下镜像是否删除完成

![](image/image_GaU9NFQgxS.png)

操作：点击还原系统，确认还原系统备份，会出现进度，等待进度条完成即可。

![](image/image_NITnFyZB_U.png)

上传进度介绍：首先点击确认后会先判断之前是否已经进行过备份镜像的操作(即环境中已经有了备份镜像)，如果存在则直接显示上传进度已经完成，开始进行还原，反之需把之前通过下载备份的操作下载的镜像上传到环境中，等待上传进度完成后，开始进行还原。

![](image/image_uRhZ_hdrW5.png)

选择上传文件后就会出现上传进度条，等待上传完成后，再等待还原成功后即好。

![](image/image_VLBAJUAdVB.png)

如果不想还原之前备份的环境，想要上传自己想要的备份环境，可以再虚拟机中进入备份存放地址：/root/back/租户名称/output.zip，删除 output.zip，再回到页面点击还原系统上传自己的备份环境即可。
