import { request } from './request';

//登录接口
export let login = (data: object | any) => request('/wx/auth/login_by_mobile', 'POST', data);

// 修改密码
export let resetPwd = (data: any) => request('/wx/auth/reset_by_mobile', 'POST', data);

// 获取订单信息
export let getOrderList = () => request('/wx/order/list', 'GET');

// 保存定制文件
export let saveCustomPage = (data: any) => request('/wx/customPage/save', 'POST', data);

// 获取用户拥有宣传页模板接口
export let getHavePage = () => request('/wx/customPage/getHavePage', 'GET');

// 查询模板
export let getPageComponent = (pageId: number) => request('/wx/customPage/getPageComponent', 'GET', pageId);

// 删除模板
export let deletePageComponent = (id: number) => request('/wx/customPage/delete', 'POST', id);

// 查询记录
export let searchSnInfo = (sn: string) => request('/wx/orderSequence/searchRecordInfo', 'GET', sn);

// 下载接口
export let downLoad = (imgUrl: string) => request('/wx/storage/download/' + imgUrl, 'GET');
