import { request } from './request';

//登录接口
export let login = (data: object | any) => request('/wx/auth/login_by_mobile', 'POST', data);

// 修改密码
export let resetPwd = (data: any) => request('/wx/auth/reset_by_mobile', 'POST', data);

// 获取订单信息
export let getMSJFList = (data?: any) => request('/wx/order/MSJFList', 'GET', data);

// 保存定制文件
export let saveCustomPage = (data: any) => request('/wx/customPage/save', 'POST', data);

// 更新定制文件
export let updateCustomPage = (data: any) => request('/wx/customPage/update', 'POST', data);

export let templateAdd = (data: any) => request('/wx/customPage/templateAdd', 'POST', data);

// 获取用户拥有宣传页模板接口
export let getHavePage = () => request('/wx/customPage/getHavePage', 'GET');

// 查询模板
export let getPageComponent = (data: any) => request('/wx/customPage/getPageComponent', 'GET', data);

// 删除模板
export let deletePageComponent = (data: any) => request('/wx/customPage/delete', 'POST', data);

// 查询记录
export let searchSnInfo = (data: any) => request('/wx/orderSequence/searchRecordInfo', 'GET', data);

// 下载接口
export let downLoad = (imgUrl: string) => request('/wx/storage/download/' + imgUrl, 'GET');

// 单个图片上传
export let singleUpload = (data: any) => request('/wx/customPage/update', 'POST', data);

// 设置默认 http://127.0.0.1:8080/wx/customPage/checked
export let customPageChecked = (data: any) => request('/wx/customPage/checked', 'POST', data)

// 获取开瓶信息
export let getMSJFDetail = (data: any) => request('/wx/order/MSJFDetail', 'GET', data)
