import { defineConfig } from 'vite'
import uni from '@dcloudio/vite-plugin-uni'

// https://vitejs.dev/config/
export default defineConfig({
 plugins: [uni()],
 server: {
  host: '0.0.0.0',
  port: 7879,
  open: true,
  strictPort: false, // 端口被占用直接退出
  proxy: {
   '/ndr': {
    target: 'http://192.168.1.12',
   },
  },
 },
 build: {
  minify: 'terser',
  terserOptions: {
   compress: {
    //生产环境时移除console
    drop_console: true,
    drop_debugger: true,
   },
  },
 },
})
