import { defineStore, createPinia } from 'pinia'
import piniaPersistConfig from '../utils/piniaPersist'
import piniaPluginPersist from 'pinia-plugin-persist'

// defineStore('global',{..}) 在devtools 就使用 global 这个名
export const useGlobalStore = defineStore('globalStore', {
  // 相当于data
  state: () => {
    return {
      // 所有这些属性都将自动推断其类型,如果推断失败可以试下 as xxx
      token: ''
    }
  },
  // 相当于计算属性
  getters: {},
  // 相当于vuex的 mutation + action，可以同时写同步和异步的代码
  actions: {
    setToken(token: string) {
      this.token = token
    },
    persist: piniaPersistConfig('globalStore')
  }
})

const pinia = createPinia()

pinia.use(piniaPluginPersist)

export default pinia
