import { PersistStrategy } from 'pinia-plugin-persist'

/**
 * @description pinia持久化参数配置
 * @param {String} key 存储到持久化的 name
 * @param {Array} paths 需要持久化的 state name
 * @return persist
 * */
const piniaPersistConfig = (key: string, paths?: any[]) => {
  const persist: PersistStrategy = {
    key,
    storage: localStorage,
    // storage: sessionStorage,
    paths
  }
  return persist
}

export default piniaPersistConfig
