// 解析 单据头与单据体数据
export const documentFilter = (list: any) => {
    const headerList: any[] = []; // 单据头数据
    const bodyList: any[] = []; // 单据体数据

    const recursiveFilter = (item: any) => {
        if (item.columns) {
            item.columns[0].list.forEach((res: any) => {
                bodyList.push(res);
            });
        }
        if (item.detailColumns) {
            item.detailColumns[0].list.forEach((res: any) => {
                if (res.type === 'table') {
                    recursiveFilter(res);
                } else if (res.type === 'grid') {
                    res.columns.forEach((col: any) => {
                        col.list.forEach((cols: any) => {
                            bodyList.push(cols);
                        });
                    });
                } else if (res.type !== 'menu_bar') {
                    bodyList.push(res);
                }
            });
        }
        bodyList.push(item);
    };

    list.forEach((item: any) => {
        if (item.type === 'table') recursiveFilter(item);
        else if (item.type === 'grid')
            item.columns.forEach((col: any) => {
                col.list.forEach((res: any) => {
                    headerList.push(res);
                });
            });
        else if (item.type !== 'menu_bar') headerList.push(item);
    });

    console.log(headerList, bodyList);
    return { headerList, bodyList }
};