import { defineConfig } from 'vite';
// import pxtovw from 'postcss-px-to-viewport'
import { resolve } from 'path';
import { createSvgIconsPlugin } from 'vite-plugin-svg-icons';
import uni from '@dcloudio/vite-plugin-uni';

export default defineConfig({
    plugins: [
        uni(),
        createSvgIconsPlugin({
            iconDirs: [resolve(process.cwd(), 'src/static/svg')],
            symbolId: 'icon-[dir]-[name]',
        }),
    ],
    resolve: {
        alias: {
            '@': resolve(__dirname, './src'),
        },
    },
    css: {
        preprocessorOptions: {
            scss: {
                additionalData: `@import "@/uni.scss";`,
            },
        },
        postcss: {
            // plugins: [loder_pxtovw]
        },
    },
    assetsInclude: '@dcloudio/uni-ui',
    build: {
        minify: 'terser',
        terserOptions: {
            compress: {
                drop_console: true, // 生产环境移除console
                drop_debugger: true, // 生产环境移除debugger
            },
        },
    },
    server: {
        host: '0.0.0.0',
        port: 7878,
        open: true,
        strictPort: false, // 端口被占用直接退出
        https: false, // 默认用http方式
        proxy: {
            '/lowcodeplatform-system': {
                target: 'http://192.168.1.156',
                // target: 'http://192.168.1.27', 
            },
            '/wms-system': {
                target: 'http://192.168.1.156',
                // target: 'http://192.168.1.27',
            },
        },
    },
});
