import { defineStore, createPinia } from 'pinia'
import piniaPluginPersistedstate from 'pinia-plugin-persistedstate'
import piniaPersistOption from './config/piniaPersist'

export const useGlobalStore = defineStore({
    id: 'globalStore',
    state() {
        return {
            token: '',
            statusBarHeight: 0,
        }
    },
    getters: {
    },
    actions: {
        setToken(token: string) {
            this.token = token
        },
        async setStatusBarHeight() {
            let that = this
            await uni.getSystemInfo({
                success(res: any) {
                    that.statusBarHeight = res.statusBarHeight || 0;
                }
            });
        }
    },
    persist: piniaPersistOption('globalStore')
})

const pinia = createPinia()
pinia.use(piniaPluginPersistedstate)

export default pinia
