import config from './config';
import { useGlobalStore } from '@/store/useStore';

const baseUrl = config.baseUrl;

// 封装公共申请办法
function request(
	url: string,
	method: 'GET' | 'POST' | 'PUT' | 'DELETE',
	data?: object | any,
	responseType?: string
) {
	return new Promise<any>(function(resolve, reject) {
		let header: any;
		const globalStore = useGlobalStore();
		uni.showLoading({
			title: '加载中...',
		});
		if (globalStore.token) {
			header = {
				'content-type': 'application/json',
				Authorization: globalStore.token,
			};
		}
		// #ifdef APP-PLUS
		url = baseUrl + url; // 在app上不需要跨域
		// #endif

		uni.request({
			url,
			method,
			data,
			header,
			responseType,
			success(res: any) {
				uni.hideLoading();
				// 判断是否存在token
				if (res.data.code == 200) {
					const pages = getCurrentPages();
					let currentRoute = pages[pages.length - 1].route;
					if (!globalStore.token && currentRoute !== 'pages/login/index')
						return uni.reLaunch({ url: '/pages/login/index' });
					resolve(res);
				} else if (res.data.code == 500 || res.data.code === 401) {
					uni.showToast({
						title: res.data.msg,
						icon: 'none',
					});
					reject(res);
				} else if (res.data.code == 501 || res.data.code == 911) {
					uni.reLaunch({
						url: '/pages/login/index',
						success() {
							globalStore.setToken('');
							uni.showToast({
								title: '请登录',
								icon: 'none',
							});
						},
					});
				} else {
					console.log(res, '非200错误');
					//其余异样
					reject(res);
				}
			},
			fail(err: any) {
				uni.hideLoading();
				//申请失败
				uni.showToast({
					title: '连接服务器失败',
					icon: 'none',
				});
				reject(err);
			},
		});
	});
}

export default request;
