import { defineStore, createPinia } from 'pinia'
import piniaPluginPersistedstate from 'pinia-plugin-persistedstate'
import piniaPersistOption from './config/piniaPersist'

export const useGlobalStore = defineStore({
    id: 'globalStore',
    state() {
        return {
            token: '',
        }
    },
    getters: {

    },
    actions: {
        setToken(token: string) {
            this.token = token
        },
    },
    persist: piniaPersistOption('globalStore')
})

const pinia = createPinia()
pinia.use(piniaPluginPersistedstate)

export default pinia
