import request from '@/utils/request';

// 获取发布菜单
export const getMenuTree = () => request('/lowcodeplatform-system/center/permission/getMenuTree', 'GET');

export const getMenuList = () => request('/lowcodeplatform-system/user/getMenuList', 'POST');

export const getBusinessList = (data: any) =>
	request('/lowcodeplatform-system/center/business/list', 'POST', data);

export const getMetadataList = () => request('/lowcodeplatform-system/center/metadata/list', 'GET');

// 获取元数据
export const getMetadata = (formId: string) =>
	request('/lowcodeplatform-system/center/metadata/detail', 'GET', { formId });
	
export const getUserParameter = (formId: string) =>
	request('/lowcodeplatform-system/center/business/getUserParameter', 'GET', { formId });

export const saveUserParameter = (data: any) =>
	request('/lowcodeplatform-system/center/business/saveUserParameter', 'POST', data);

// 获取序列号扫描数据
export const getDataBySerialNumber = (data: any) =>
	request('/wms-system/serialNumber/getDataBySerialNumber', 'GET', data);

// 获取打印信息
export const getPrintData = (data: any) =>
	request('/wms-system/labelRule/print/serial', 'POST', data);

// 获取打印信息
export const createBusiness = (data: any) =>
	request('/lowcodeplatform-system/center/business/createBatch', 'POST', data);

// 获取序列化
export const getByBillNo = (data: any) =>
	request('/wms-system/serialNumber/getByBillNo', 'GET', data);

// 获取条码规则 
export const getAnalysis = (data: any) =>
	request('/wms-system/barcode/analysis', 'GET', data);