import { createSSRApp } from 'vue'
import { broadcastScan } from './utils/scanCode'
import App from './App.vue'
import uView from 'vk-uview-ui'
import config from '@/utils/config'
import pinia from './store/useStore'
import 'virtual:svg-icons-register'

export function createApp() {
    const app = createSSRApp(App)
    app.config.globalProperties.$baseUrl = config.baseUrl
    app.config.globalProperties.$broadcastScan = broadcastScan
    app.use(uView)
    app.use(pinia)
    return {
        app,
    }
}
