export const zconfirm = (msg: string, callBackFun?: any) => {
  uni.showModal({
    content: msg,
    success(res) {
      if (res.confirm) {
        callBackFun(true)
      } else if (res.cancel) {
        callBackFun(false)
      }
    },
  })
}
export const zalert = (msg: string, callBackFun?: any) => {
  uni.showModal({
    title: '提示',
    content: msg,
    showCancel: false,
    success() {
      if (callBackFun) {
        callBackFun()
      }
    },
  })
}
export const toast = (msg: string) => {
  uni.showToast({
    title: msg,
    duration: 2000,
    mask: false,
    icon: 'none',
  })
}

export const sLoading = (msg: string = '加载中...') => {
  uni.showLoading({
    title: msg,
    mask: true
  })
}

export const hLoading = () => {
  uni.hideLoading()
}

// 防抖
interface DebounceFunc<T extends (...args: any[]) => any> {
  (this: ThisParameterType<T>, ...args: Parameters<T>): ReturnType<T>;
}

export function debounce<T extends (...args: any[]) => any>(
  fn: T,
  delay = 300,
): DebounceFunc<T> {
  let timer: number | null;
  return function (this: ThisParameterType<T>, ...args: Parameters<T>) {
    if (timer) clearTimeout(timer);
    timer = setTimeout(() => {
      fn.call(this, ...args);
    }, delay);
  } as DebounceFunc<T>;
}