import request from '@/utils/request';

// 获取发布菜单
export const getMenuTree = () => request('/lowcodeplatform-system/center/permission/getMenuTree', 'GET');

export const getMenuList = () => request('/lowcodeplatform-system/user/getMenuList', 'POST');

export const getBusinessList = (data: any) =>
	request('/lowcodeplatform-system/center/business/list', 'POST', data);

export const getMetadataList = () => request('/lowcodeplatform-system/center/metadata/list', 'GET');

// 获取元数据
export const getMetadata = (formId: string) =>
	request('/lowcodeplatform-system/center/metadata/detail', 'GET', { formId });

// 创建表单数据	
export const createBusiness = (data: any) =>
	request('/lowcodeplatform-system/center/business/create', 'POST', data);

export const getUserParameter = (formId: string) =>
	request('/lowcodeplatform-system/center/business/getUserParameter', 'GET', { formId });

export const saveUserParameter = (data: any) =>
	request('/lowcodeplatform-system/center/business/saveUserParameter', 'POST', data);

// 获取序列号扫描数据
export const getDataBySerialNumber = (data: any) =>
	request('/wms-system/serialNumber/getDataBySerialNumber', 'GET', data);

// 获取打印信息
export const getPrintData = (data: any) =>
	request('/wms-system/labelRule/print/serial', 'POST', data);

// 获取打印信息
export const createBatchBusiness = (data: any) =>
	request('/lowcodeplatform-system/center/business/createBatch', 'POST', data);

// 获取序列化
export const getBillSerialNumber = (data: any) =>
	request('/wms-system/serialNumber/getBillSerialNumber', 'GET', data);

// 获取条码规则 
export const getAnalysis = (data: any) =>
	request('/wms-system/barcode/analysis', 'GET', data);

// 获取规则选单
export const getRuleSelection = (lowFormId: string) =>
	request('/lowcodeplatform-system/center/bill/transform/rule/selection', 'GET', { lowFormId });

// 获取规则选单
export const changeDataById = (data: any) =>
	request('/lowcodeplatform-system/center/bill/transform/change/databyid', 'POST', data);

// 获取明细范围
export const getDetailList = (data: any) =>
	request('/lowcodeplatform-system/center/business/detailList', 'POST', data);

// 获取合并数量操作
export const getEmptyList = (data: any) =>
	request('/lowcodeplatform-system/center/business/empty', 'POST', data);

/**
 * @brief 提交下推操作保存为已审核
 * @param  idsBill 保存状态的id
 * @param  operationKey audit 自动审核-》已审核   submit 提交-》变成审核中
 * @return  
 */
export const submitBusiness = (data: any) =>
	request('/lowcodeplatform-system/center/business/submit', 'POST', data);

export const billIdGroupSerial = (data: any) =>
	request('wms-system/serialNumber/billIdGroupSerial', 'POST', data);

// 判断是否已创建
export const getBillBySerialNumber = (data: any) =>
	request('/wms-system/serialNumber/getBillBySerialNumber', 'GET', data);
