
/**
 * @brief 解析 单据头与单据体数据(扁平化处理)
 * @param list[]
 * @return { headerList , bodyList }
 */
export const documentFilter = (list: any) => {
    const headerList: any[] = []; // 单据头数据
    const bodyList: any[] = []; // 单据体数据
    const bodyModel: any[] = []

    const recursiveFilter = (item: any) => {
        if (item.columns) {
            item.columns[0].list.forEach((res: any) => {
                bodyList.push(res);
            });
        }
        if (item.detailColumns) {
            item.detailColumns[0].list.forEach((res: any) => {
                if (res.type === 'table') {
                    recursiveFilter(res);
                } else if (res.type === 'grid') {
                    res.columns.forEach((col: any) => {
                        col.list.forEach((cols: any) => {
                            bodyList.push(cols);
                        });
                    });
                } else if (res.type !== 'menu_bar') {
                    bodyList.push(res);
                }
            });
        }
        bodyList.push(item);
    };

    list.forEach((item: any) => {
        if (item.type === 'table') {
            bodyModel.push(item.model)
            recursiveFilter(item);
        }
        else if (item.type === 'grid')
            item.columns.forEach((col: any) => {
                col.list.forEach((res: any) => {
                    headerList.push(res);
                });
            });
        else if (item.type !== 'menu_bar') headerList.push(item);
    });
    return { headerList, bodyList, bodyModel }
};

/**
 * @brief 获取移动端表单可见的值
 * @param list[]
 * @return { [mobileList] }
 */
export const filterList = (list: any[]) => {
    let mobileList = [] as any[];
    const recursiveFilter = (item: any) => {
        if (item.columns)
            item.columns[0].list.map((res: any) => {
                if (
                    res.options.visibility &&
                    res.options.visibility.indexOf('mobile_form_visible') !== -1
                )
                    mobileList = [...mobileList, res];
            });

        if (item.detailColumns)
            item.detailColumns[0].list.forEach((res: any) => {
                recursiveFilter(res);
            });

        if (
            item.options.visibility &&
            item.options.visibility.indexOf('mobile_form_visible') !== -1
        )
            mobileList = [...mobileList, item];
    };
    list.forEach(item => recursiveFilter(item));
    return mobileList;
};

/**
 * @brief 获取过滤表单的是否存在的值
 * @param list[]
 * @param FilterConditions 过滤条件 字符串类型
 * @return { list }
 */
export const filterSpecified = (list: any[], FilterConditions: string) => {
    return list.filter((item: any) => eval(FilterConditions))
}

export const baseDataFilter = (list: any[], baseList: any[]) => {
    // console.log(list, baseList);
    let mobileList = [] as any[];
    let dataList = [] as any[];
    const recursiveFilter = (item: any) => {
        if (item.columns)
            item.columns[0].list.map((res: any) => {
                if (
                    res.type == 'basic_data' ||
                    res.type == 'basic_data_edit' &&
                    res.options.remoteFunc
                )
                    mobileList = [...mobileList, res];
            });

        if (item.detailColumns)
            item.detailColumns[0].list.forEach((res: any) => {
                recursiveFilter(res);
            });

        if (
            item.type == 'basic_data' ||
            item.type == 'basic_data_edit' &&
            item.options.remoteFunc
        )
            mobileList = [...mobileList, item];
    };
    list.forEach(item => recursiveFilter(item));
    // console.log(mobileList, 'mobileList');
    console.log(list, baseList);

    for (const k in baseList) {
        mobileList.map((item: any) => {
            if (item.options.remoteFunc === k) {
                let obj = {} as any
                const label = item.options.props.label
                const value = item.options.props.value
                if (baseList[k].length && baseList[k][0][label]) obj['label'] = baseList[k][0][label]
                if (baseList[k].length && baseList[k][0][value]) obj['value'] = baseList[k][0][value]
                if (obj) dataList.push(obj)
            }
        })
    }
    return dataList
}

/**
 * @brief 单据体model数据扁平化
* @param data[] 单据体model数据
* @param flattenedData {}
* @return { flattenedData }
*/
export const flattenData = (data: any[]) => {
    let flattenedData: any = {};
    const flattenObject = (obj: any) => {
        const flattenedObj: any = {};
        for (let key in obj) {
            if (typeof obj[key] === 'object') {
                const nestedObj = flattenObject(obj[key]);
                for (let nestedKey in nestedObj) {
                    // flattenedObj[key + '.' + nestedKey] = nestedObj[nestedKey];
                    flattenedObj[nestedKey] = nestedObj[nestedKey];
                }
            } else {
                flattenedObj[key] = obj[key];
            }
        }
        return flattenedObj;
    };
    for (let item of data) {
        flattenedData = { ...flattenedData, ...flattenObject(item) }
        // flattenedData.push(flattenObject(item));
    }
    return flattenedData;
};

export const dataListFilter = (list: any[], obj: any) => {
    let dataList = [] as any[]
    list.map((item: any) => {
        let dataObj = {} as any
        for (const key in obj) {
            if (item.model === key) {
                dataObj['label'] = item.label + '：'
                dataObj['value'] = obj[key]
            }
        }
        if (JSON.stringify(dataObj) === '{}') {
            dataObj['label'] = item.label + '：'
            dataObj['value'] = ''
        }
        dataList.push(dataObj)
    })
    return dataList
}

export const mergeList = (list: any[]) => {
    const { subSystem, permTag: formId } = JSON.parse(uni.getStorageSync('pageData'));
    const data = {
        formId,
        subSystem,
        list: [] as any
    }
    for (const item of list) {
        let isAdded = false;
        // 如果列表为空，则添加数据
        if (data.list.length === 0) {
            data.list.push(item);
            continue;
        }
        for (const res of data.list) {
            // 查找相同供应商ID的元素
            if (res.FSupplyId === item.FSupplyId) {
                for (const wms of res.WMS_InStockEntry) {
                    // 查找相同物料ID和批次号的元素
                    if (item.WMS_InStockEntry[0].FLot === wms.FLot &&
                        item.WMS_InStockEntry[0].FMaterialId === wms.FMaterialId) {
                        wms.WMS_InStockSERIAL.push(item.WMS_InStockEntry[0].WMS_InStockSERIAL[0]);
                        isAdded = true;
                        break;
                    }
                }
                // 如果没有找到相同物料ID和批次号的元素，则在其中新增一条数据
                if (!isAdded) {
                    res.WMS_InStockEntry.push(item.WMS_InStockEntry[0]);
                    isAdded = true;
                }
                break;
            }
        }
        // 如果列表中没有相同供应商ID的元素，则在其中新增一条数据
        if (!isAdded) {
            data.list.push(item);
        }
    }
    return data;
}