import { defineStore } from 'pinia';

let sysinfo = uni.getSystemInfoSync();

export const useBlueTooth = defineStore({
	id: 'blueTooth',
	state: () => ({
		sysinfo: uni.getSystemInfoSync(),
		blueToothList: [],
		BLEInformation: {
			platform: sysinfo.platform || "",
			deviceId: "",
			writeCharaterId: "",
			writeServiceId: "",
			notifyCharaterId: "",
			notifyServiceId: "",
			readCharaterId: "",
			readServiceId: "",
		}
	}),
	getters: {
		getBlueTooth(blueToothList: any) {
			this.blueToothList = blueToothList;
		},
		BLEInformationSet(info: any) {
			this.BLEInformation = info;
		}
	},
});
