import { request } from '../config'

const API_COMMON = '/'

export function getQueryTreeList() {
	return request({
		url: API_COMMON + 'permission/queryTreeList'
	})
}

export function getRoleList(params: any) {
	return request({
		url: '/role/list',
		method: 'get',
		params
	})
}
export function deleteRoleList(id: number) {
	return request({
		url: '/role/delete',
		method: 'delete',
		params: { id }
	})
}
export function editRoleList(data: any) {
	return request({
		url: '/role/edit',
		method: 'put',
		data
	})
}
export function addRoleList(data: any) {
	return request({
		url: '/role/add',
		method: 'post',
		data
	})
}

export function getQueryRoleMenu(params: { id: string }) {
	return request({
		url: API_COMMON + 'permission/queryRolePermission',
		params
	})
}

export function saveRole(data: {
	lastPermissionIds: string[],
	permissionIds: string[],
	roleId: string
}) {
	return request({
		url: API_COMMON + 'permission/saveRolePermission',
		method: 'post',
		data
	})
}
