export type Method = 'GET' | 'POST' | 'PUT' | 'DELETE'
export type ResponseType = 'arraybuffer' | 'blob' | 'document' | 'json' | 'text' | 'stream'

export interface AxiosRequest {
    baseURL?: string;
    url: string;
    data?: object;
    params?: object;
    method?: Method;
    headers?: object;
    timeout?: number;
    responseType?: ResponseType;
}

export interface AxiosResponseReult<T = any> {
    data: T;
    headers: object;
    request?: object;
    status: number;
    statusText: string;
    config?: AxiosRequest;
}

export interface CustomResponse<T = any> {
    menuList: T;
    status: boolean;
    message: string;
    code: string | number;
    data: T;
    origin?: any;
    msg:string;
}


