import { request } from '../config'

export function fetchList(params: any) {
    return request({
        url: '/user/list',
        method: 'get',
        params
    })
}

export function userDetails(id: number) {
    return request({
        url: '/user/detail',
        method: 'get',
        params: { id }
    })
}

export function updateUser(data: any) {
    return request({
        url: '/user/update',
        method: 'post',
        data
    })
}

export function listAddress(params: any) {
    return request({
        url: '/address/list',
        method: 'get',
        params: params
    })
}

export function listCollect(params: any) {
    return request({
        url: '/collect/list',
        method: 'get',
        params
    })
}

export function listFeedback(params: any) {
    return request({
        url: '/feedback/list',
        method: 'get',
        params
    })
}

export function listFootprint(params: any) {
    return request({
        url: '/footprint/list',
        method: 'get',
        params
    })
}

export function listHistory(params: any) {
    return request({
        url: '/history/list',
        method: 'get',
        params
    })
}
