export const cacheStorage = {

    /**
     * 设置永久缓存
     * @param key 键值
     * @param val 值，
     */
    setLocalStorage(key: string, val: any) {
        localStorage.setItem(key, JSON.stringify(val));
    },

    /**
     * 获取永久缓存
     * @param key 键值
     * @returns 返回序列号的json值
     */
    getLocalStorage(key: string) {
        const json: any = window.localStorage.getItem(key);
        return JSON.parse(json);
    },

    /**
     * 
     * @param key 本地缓存键值
     */
    removeLocalStorage(key: string) {
        localStorage.removeItem(key);
    },

    /**
     *移除全部永久缓存
     *
     */
    clearLocalStorage() {
        localStorage.clear();
    },


    /**
     * 设置临时缓存
     * @param key 键值
     * @param val 内容，将序列化缓存
     */
    setSessionStorage(key: string, val: any) {
        sessionStorage.setItem(key, JSON.stringify(val));
    },

    /**
     * 获取临时缓存
     * @param key 键值
     * @returns 返回反序列后的内容
     */
    getSessionStorage(key: string) {
        const json: any = window.sessionStorage.getItem(key);
        return JSON.parse(json);
    },

    /**
     *移除临时缓存
     *
     * @param key 键值
     */
    removeSessionStorage(key: string) {
        sessionStorage.removeItem(key);
    },

    /**
     * 移除全部临时缓存
     */
    clearSessionStorage() {
        sessionStorage.clear();
    }


}
