import {ColumnsModel,ButtonListModel} from '@/services/types/table/tableModel'

export type TableState = {
    columns:Array<ColumnsModel>,
    data:Array<object>,
    buttonList:Array<ButtonListModel>
}

export const state:TableState = {
    columns:[],
    data:[],
    buttonList:[]

}

export const mutations = {
    setColunms:(state:TableState,col:Array<ColumnsModel>) => {
        state.columns = col
    },
    setData:(state:TableState,data:Array<object>) => {
        state.data = data
    },
    setButtonList:(state:TableState,buttonList:Array<ButtonListModel>) => {
        state.buttonList = buttonList
    }
}

export const getters = {
    getColumns:(state:TableState) => {
        return state.columns
    },
    getData:(state:TableState) => {
        return state.data
    },
    getButtonList:(state:TableState) => {
        return state.buttonList
    }
}

export default {
    namespaced:true,
    state,
    mutations,
    getters
}