import { InjectionKey } from 'vue';
import { useStore as baseUseStore, createStore, Store } from 'vuex';
import menu, { MenuState } from '@/store/modules/menu'
import tabs, { TabsState } from '@/store/modules/tabs'
import user, { UserState } from '@/store/modules/user'
import table, { TableState } from "@/store/modules/table";
import search, { SearchState } from "@/store/modules/search";
import socket, { SocketState } from '@/store/modules/socket';
import { StarbosStore } from './tools';


export type RootState = {
    tabs: TabsState,
    menu: MenuState,
    user: UserState,
    table: TableState,
    socket: SocketState,
    search: SearchState
}
//导入所有的模块
export const modules = {
    tabs: tabs,
    menu: menu,
    user: user,
    table: table,
    socket: socket,
    search: search
}

export const key: InjectionKey<Store<RootState>> = Symbol()

export const store = createStore<RootState>({
    modules
}) as StarbosStore

// 定义自己的 `useStore` 组合式函数
export function useStore() {
    return baseUseStore(key) as StarbosStore
}
