export function throttle(fn: () => void, time = 2000){
    let canRun: boolean = true;
    return function () {
        if (!canRun) return;
        canRun = false;
        setTimeout(() => {
            fn()
            canRun = true;
        },time);
    }
}

export function debounce(fn: () => void, t:number) {
    let timeId: NodeJS.Timeout | null = null
    const delay = t || 1000
    return function (this: any, ...args: any) {
        if(timeId) clearTimeout(timeId)
        timeId = setTimeout(()=> {
            timeId = null
            fn.apply(this, args)
        },delay)
    }
}
