import { request } from '../config'
import Qs from 'qs'

export function listOrder(query: any) {
  return request({
    url: '/order/list',
    method: 'get',
    params: query,
    paramsSerializer: (params: any) => {
      return Qs.stringify(params, { arrayFormat: 'repeat' })
    }
  })
}

export function detailOrder(id: number) {
  return request({
    url: '/order/detail',
    method: 'get',
    params: { id }
  })
}

export function shipOrder(data: any) {
  return request({
    url: '/order/ship',
    method: 'post',
    data
  })
}

export function refundOrder(data: any) {
  return request({
    url: '/order/refund',
    method: 'post',
    data
  })
}

export function payOrder(data: any) {
  return request({
    url: '/order/pay',
    method: 'post',
    data
  })
}

export function deleteOrder(data: any) {
  return request({
    url: '/order/delete',
    method: 'post',
    data
  })
}

export function replyComment(data: any) {
  return request({
    url: '/order/reply',
    method: 'post',
    data
  })
}

export function listChannel(id?: any) {
  return request({
    url: '/order/channel',
    method: 'get',
    params: { id }
  })
}
