import { request } from '../config'

// 字典管理
export function getDictList(params?: any) {
    return request({
        url: '/sys/dict/list',
        method: 'get',
        params
    })
}

export function addDict(data: any) {
    return request({
        url: '/sys/dict/add',
        method: 'post',
        data
    })
}

export function editDict(data: any) {
    return request({
        url: '/sys/dict/edit',
        method: 'put',
        data
    })
}

export function deleteDict(id: number) {
    return request({
        url: '/sys/dict/delete',
        method: 'delete',
        params: { id }
    })
}

// 字典配置管理
export function getDictItemList(params: any) {
    return request({
        url: '/sys/dictItem/list',
        method: 'get',
        params
    })
}

export function addDictItem(data: any) {
    return request({
        url: '/sys/dictItem/add',
        method: 'post',
        data
    })
}

export function editDictItem(data: any) {
    return request({
        url: '/sys/dictItem/edit',
        method: 'put',
        data
    })
}

export function deleteDictItem(id: number) {
    return request({
        url: '/sys/dictItem/delete',
        method: 'delete',
        params: { id }
    })
}
