/**
 * Created by jiachenpan on 16/11/18.
 */

 export function parseTime(time: any, cFormat: any) {
    if (arguments.length === 0) {
      return null;
    }
    const format = cFormat || "{y}-{m}-{d} {h}:{i}:{s}";
    let date: any;
    if (typeof time === "object") {
      date = time;
    } else {
      if (("" + time).length === 10) time = parseInt(time) * 1000;
      date = new Date(time);
    }
    const formatObj = {
      y: date.getFullYear(),
      m: date.getMonth() + 1,
      d: date.getDate(),
      h: date.getHours(),
      i: date.getMinutes(),
      s: date.getSeconds(),
      a: date.getDay(),
    } as any;
    const time_str = format.replace(
      /{(y|m|d|h|i|s|a)+}/g,
      (result: any, key: any) => {
        let value = formatObj[key];
        // Note: getDay() returns 0 on Sunday
        if (key === "a") {
          return ["日", "一", "二", "三", "四", "五", "六"][value];
        }
        if (result.length > 0 && value < 10) {
          value = "0" + value;
        }
        return value || 0;
      }
    );
    return time_str;
  }
  
  // NOTE: 这里的缩略图只用于阿里云存储。
  // 开发者可以参考其他云存储的缩略图参数。
  export function thumbnail(src: any) {
    return src + "?x-oss-process=image/resize,m_lfit,h_250,w_250";
  }
  
  export function toPreview(item: any, url: any) {
    item.preview = [url];
    return item.preview;
  }
  
  export function formatTime(time: any, option: any) {
    time = +time * 1000;
    const d = new Date(time) as any;
    const now = Date.now();
  
    const diff = (now - d) / 1000;
  
    if (diff < 30) {
      return "刚刚";
    } else if (diff < 3600) {
      // less 1 hour
      return Math.ceil(diff / 60) + "分钟前";
    } else if (diff < 3600 * 24) {
      return Math.ceil(diff / 3600) + "小时前";
    } else if (diff < 3600 * 24 * 2) {
      return "1天前";
    }
    if (option) {
      return parseTime(time, option);
    } else {
      return (
        d.getMonth() +
        1 +
        "月" +
        d.getDate() +
        "日" +
        d.getHours() +
        "时" +
        d.getMinutes() +
        "分"
      );
    }
  }
  
  // 格式化时间
  export function getQueryObject(url: any) {
    url = url == null ? window.location.href : url;
    const search = url.substring(url.lastIndexOf("?") + 1);
    const obj = {} as any;
    const reg = /([^?&=]+)=([^?&=]*)/g;
    search.replace(reg, (rs: any, $1: any, $2: any) => {
      const name = decodeURIComponent($1);
      let val = decodeURIComponent($2);
      val = String(val);
      obj[name] = val;
      return rs;
    });
    return obj;
  }
  
  /**
   *get getByteLen
   * @param {Sting} val input value
   * @returns {number} output value
   */
  export function getByteLen(val: any) {
    let len = 0;
    for (let i = 0; i < val.length; i++) {
      if (val[i].match(/[^\x00-\xff]/gi) != null) {
        len += 1;
      } else {
        len += 0.5;
      }
    }
    return Math.floor(len);
  }
  
  export function cleanArray(actual: any) {
    const newArray = [];
    for (let i = 0; i < actual.length; i++) {
      if (actual[i]) {
        newArray.push(actual[i]);
      }
    }
    return newArray;
  }
  
  export function param(json: any) {
    if (!json) return "";
    return cleanArray(
      Object.keys(json).map((key) => {
        if (json[key] === undefined) return "";
        return encodeURIComponent(key) + "=" + encodeURIComponent(json[key]);
      })
    ).join("&");
  }
  
  export function param2Obj(url: any) {
    const search = url.split("?")[1];
    if (!search) {
      return {};
    }
    return JSON.parse(
      '{"' +
        decodeURIComponent(search)
          .replace(/"/g, '\\"')
          .replace(/&/g, '","')
          .replace(/=/g, '":"') +
        '"}'
    );
  }
  
  export function html2Text(val: any) {
    const div = document.createElement("div");
    div.innerHTML = val;
    return div.textContent || div.innerText;
  }
  
  export function objectMerge(target: any, source: any) {
    /* Merges two  objects,
       giving the last one precedence */
  
    if (typeof target !== "object") {
      target = {};
    }
    if (Array.isArray(source)) {
      return source.slice();
    }
    Object.keys(source).forEach((property: any) => {
      const sourceProperty = source[property];
      if (typeof sourceProperty === "object") {
        target[property] = objectMerge(target[property], sourceProperty);
      } else {
        target[property] = sourceProperty;
      }
    });
    return target;
  }
  
  export function toggleClass(element: any, className: any) {
    if (!element || !className) {
      return;
    }
    let classString = element.className;
    const nameIndex = classString.indexOf(className);
    if (nameIndex === -1) {
      classString += "" + className;
    } else {
      classString =
        classString.substr(0, nameIndex) +
        classString.substr(nameIndex + className.length);
    }
    element.className = classString;
  }
  
  export const pickerOptions = [
    {
      text: "今天",
      onClick(picker: any) {
        const end = new Date();
        const start = new Date(new Date().toDateString());
        end.setTime(start.getTime());
        picker.$emit("pick", [start, end]);
      },
    },
    {
      text: "最近一周",
      onClick(picker: any) {
        const end = new Date(new Date().toDateString());
        const start = new Date();
        start.setTime(end.getTime() - 3600 * 1000 * 24 * 7);
        picker.$emit("pick", [start, end]);
      },
    },
    {
      text: "最近一个月",
      onClick(picker: any) {
        const end = new Date(new Date().toDateString());
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * 30);
        picker.$emit("pick", [start, end]);
      },
    },
    {
      text: "最近三个月",
      onClick(picker: any) {
        const end = new Date(new Date().toDateString());
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * 90);
        picker.$emit("pick", [start, end]);
      },
    },
  ];
  
  export function getTime(type: any) {
    if (type === "start") {
      return new Date().getTime() - 3600 * 1000 * 24 * 90;
    } else {
      return new Date(new Date().toDateString());
    }
  }
  
  export function debounce(func: any, wait: any, immediate: any) {
    let timeout: any, args: any, context: any, timestamp: any, result: any;
  
    const later = function () {
      // 据上一次触发时间间隔
      const last = +new Date() - timestamp;
  
      // 上次被包装函数被调用时间间隔last小于设定时间间隔wait
      if (last < wait && last > 0) {
        timeout = setTimeout(later, wait - last);
      } else {
        timeout = null;
        // 如果设定为immediate===true，因为开始边界已经调用过了此处无需调用
        if (!immediate) {
          result = func.apply(context, args);
          if (!timeout) context = args = null;
        }
      }
    };
  
    return function (...args: any) {
    //   context = this;
      timestamp = +new Date();
      const callNow = immediate && !timeout;
      // 如果延时不存在，重新设定延时
      if (!timeout) timeout = setTimeout(later, wait);
      if (callNow) {
        result = func.apply(context, args);
        context = args = null;
      }
  
      return result;
    };
  }
  
  /**
   * This is just a simple version of deep copy
   * Has a lot of edge cases bug
   * If you want to use a perfect deep copy, use lodash's _.cloneDeep
   */
  export function deepClone(source: any) {
    if (!source && typeof source !== "object") {
      throw new Error("error arguments", "shallowClone");
    }
    const targetObj: any = source.constructor === Array ? [] : {};
    Object.keys(source).forEach((keys: any) => {
      if (source[keys] && typeof source[keys] === "object") {
        targetObj[keys] = deepClone(source[keys]);
      } else {
        targetObj[keys] = source[keys];
      }
    });
    return targetObj;
  }
  
  export function uniqueArr(arr: any) {
    return Array.from(new Set(arr));
  }
  
  export function isExternal(path: any) {
    return /^(https?:|mailto:|tel:)/.test(path);
  }
  