import { build, defineConfig } from "vite";
import vue from "@vitejs/plugin-vue";
// vite 提供的操作env配置变量的方法loadEnv
import { loadEnv } from "vite";
// nodejs写法，获取项目目录
import path from "path";

//按需要加载
import AutoImport from "unplugin-auto-import/vite";
import Components from "unplugin-vue-components/vite";
import { ElementPlusResolver } from "unplugin-vue-components/resolvers";
import Icons from "unplugin-icons/vite";
import IconsResolver from "unplugin-icons/resolver";
import Inspect from "vite-plugin-inspect";
//import { viteMockServe } from "vite-plugin-mock";
import { createSvgIconsPlugin } from "vite-plugin-svg-icons";
const pathSrc = path.resolve(__dirname, "src");

// https://vitejs.dev/config/
export default ({ command, mode }) => {
  const env = loadEnv(mode, process.cwd());
  return defineConfig({
    plugins: [
      vue(),
      createSvgIconsPlugin({
        // 指定需要缓存的图标文件夹
        iconDirs: [
          path.resolve(process.cwd(), "src/assets/icons"),
          path.resolve(process.cwd(), "src/vueFormCreate/icons/svg")
        ],
        // 指定symbolId格式
        symbolId: "icon-[dir]-[name]",
      }),
      Inspect(),
    ],
    // 服务器配置
    server: {
      host: "0.0.0.0",
      port: Number(loadEnv(mode, process.cwd()).VITE_APP_PORT),
      strictPort: false, // 端口被占用直接退出
      https: false, // 默认用http方式
      open: true, // 在开发服务器启动时自动在浏览器中打开应用程序
      proxy: {
        // 代理配置
        // 字符串简写写法
        // '/foo': '',
        // 选项写法
        "/admin": {
          target: "http://192.168.0.60:82/",
          //  rewrite: (path) => path.replace(/^\/api/, '') http://192.168.0.9:8089/
        },
        "/wx": {
          target: "http://192.168.0.60:82/",
          //  rewrite: (path) => path.replace(/^\/api/, '')
        },
        // 正则表达式写法
        // '^/fallback/.*': {
        //   target: 'http://jsonplaceholder.typicode.com',
        //   changeOrigin: true,
        //   rewrite: (path) => path.replace(/^\/fallback/, '')
        // },
      },
      hmr: {
        overlay: true, // 屏蔽服务器报错
      },
    },
    resolve: {
      // 设置项目文件导入路径
      alias: {
        "@": pathSrc,
      },
    },
    css: {
      // css预处理器
      preprocessorOptions: {
        // 引入 var.scss 这样就可以在全局中使用 var.scss中预定义的变量了
        // 给导入的路径最后加上 ;

        scss: {
          charset: false, //防止样式出现警告，中文
          additionalData: '@import "@/assets/styles/global.scss";',
        },
      },
    },
    build: {
      minify : 'terser',
      // 分块打包配置
      chunkSizeWarningLimit: 1500, // 分块打包，分解块，将大块分解成更小的块
      rollupOptions: {
        output: {
          manualChunks(id) {
            if (id.includes("node_modules")) {
              return id
                .toString()
                .split("node_modules/")[1]
                .split("/")[0]
                .toString();
            }
          },
        },
      },
      terserOptions: {
        compress: {
          drop_console: true, // 生产环境移除console
          drop_debugger: true, // 生产环境移除debugger
        },
      },
    },
  });
};
