import { ref, onMounted } from 'vue'
import { getImagApi } from '@/services/api/user/userAPI';
import { ElNotification } from 'element-plus';
import {debounce} from '@/utils/debounce_throttle'
export default function useImage() {

    //定义图片src
    const imgSrc = ref('../../../../checkcode.png');

    // 获取图片
    //btoa 创建一个base64编码的字符串
    const getImage = debounce(async () => {
        await getImagApi().then(res => {
            return res.data.data as string;
        }).then(data => {
            imgSrc.value = data;
        }).catch((err) => {
            ElNotification({
                title:'获取验证码失败',
                message:err.message,
                type:'error',
            })
        })
    },1000)
    onMounted(() => {
        getImage()
    })
    return {
        imgSrc,
        getImage
    }
}