import { getCurrentInstance, ComponentInternalInstance } from "vue-demi";

export default function useInstance() {
    // 获取当前组件实例,proxy生产和开发环境可以用，开发环境下可以使用ctx，生产环境不允许ctx，会引起获取不到实例
    const { appContext, proxy } = getCurrentInstance() as ComponentInternalInstance
    const global = appContext.config.globalProperties;
    return {
        proxy,
        global
    }
}