import { request  } from '../config'

const API_COMMON = '/'

export function getQueryTreeList() {
	return request({
		url: API_COMMON + 'permission/queryTreeList'
	})
}

export function getQueryRoleMenu(params: { id: string }) {
	return request({
		url: API_COMMON + 'permission/queryRolePermission',
		params
	})
}

export function saveRole(data: {
	lastPermissionIds: string[],
	permissionIds: string[],
	roleId: string
}) {
	return request({
		url: API_COMMON + 'permission/saveRolePermission',
		method: 'post',
		data
	})
}
