import httpRequest from "@/services/common";
import { userUrlConfig,authUrlConfig } from '@/services/config'


//获取菜单
export const getMenuListApi = async () => {
    return await httpRequest.post(userUrlConfig["getMenuList"],{})
}

//获取菜单树
export const getMenuTree = async () => {
    return await httpRequest.get(authUrlConfig['getMenuTree'])
}

//获取全部菜单树
export const queryTreeList = async () => {
    return await httpRequest.get(authUrlConfig['queryTreeList'])
}

//添加菜单
export const addMenu = async (param:object) => {
    return await httpRequest.post(authUrlConfig['addMenu'],param)
}

//编辑菜单
export const editMenu = async (param:object) => {
    return await httpRequest.post(authUrlConfig['editMenu'],param)
}

//删除菜单
export const deleteMenu = async (param:object) => {
    return await httpRequest.delete(authUrlConfig['deleteMenu'],param)
}

//查询角色权限
export const queryRoleMenu = async (param:object) => {
    return await httpRequest.get(authUrlConfig['queryRoleMenu'],param)
}