 /**
  *请求结果定义
  *
  * @enum {number}
  */
 enum ResultEnum {
    SUCCESS = 0,
    ERROR = 1,
    TIMEOUT = 401,
    TYPE = 'success',
  }

 /**
  *请求类型
  *
  * @enum {number}
  */
 enum RequestEnum {
    GET = 'GET',
    POST = 'POST',
    PUT = 'PUT',
    DELETE = 'DELETE',
  }


 /**
  *请求类型
  *
  * @enum {number}
  */
 enum ContentTypeEnum {
    // json
    JSON = 'application/json;charset=UTF-8',
    // form-data qs
    FORM_URLENCODED = 'application/x-www-form-urlencoded;charset=UTF-8',
    // form-data  upload
    FORM_DATA = 'multipart/form-data;charset=UTF-8',
  }

  /**
   *请求配置
   *
   * @enum {number}
   */
  enum ConfigEnum {
    // TOKEN
    TOKEN = 'X-Access-Token',
  }
  export { RequestEnum, ResultEnum, ContentTypeEnum, ConfigEnum }