import { request } from '../config'

export function listGoods(params: any) {
  return request({
    url: '/goods/list',
    method: 'get',
    params
  })
}

export function deleteGoods(data: any) {
  return request({
    url: '/goods/delete',
    method: 'post',
    data
  })
}

export function publishGoods(data: any) {
  return request({
    url: '/goods/create',
    method: 'post',
    data
  })
}

export function detailGoods(id: number) {
  return request({
    url: '/goods/detail',
    method: 'get',
    params: { id }
  })
}

export function editGoods(data: any) {
  return request({
    url: '/goods/update',
    method: 'post',
    data
  })
}

export function listCatAndBrand() {
  return request({
    url: '/goods/catAndBrand',
    method: 'get'
  })
}
