import { createRouter, createWebHashHistory, RouteRecordRaw } from "vue-router";
import Layout from "@/layout/index.vue";
const routes: Array<RouteRecordRaw> = [
  {
    path: "/",
    component: Layout,
    redirect: "/dashboard",
    children: [
      {
        path: "/dashboard",
        component: () => import("@/views/dashboard/index.vue"),
        name: "dashboard",
        meta: {
          title: "首页",
          icon: "#icondashboard",
        },
      },
    ],
  },
  {
    path: "/commodity",
    component: Layout,
    children: [
      {
        path: "/commodity/edit",
        component: () => import("@/views/commodityManage/edit.vue"),
        name: "edit",
        meta: {
          title: "商品编辑",
          icon: "",
        },
      },
    ],
  },
  {
    path: "/login",
    name: "login",
    component: () => import("@/views/login/login.vue"),
  },
  {
    path: "/import/lic",
    name: "importLic",
    component: () => import("@/views/login/importLic.vue"),
  },
  {
    path: "/404",
    name: "404",
    component: () => import("@/views/exception/404.vue"),
  },
  // {
  //     path: '/:catchAll(.*)',
  //     redirect: '/404'
  // }
];

export const asyncRoutes: Array<RouteRecordRaw> = [];

const router = createRouter({
  history: createWebHashHistory(),
  // routes = routes:routes
  routes,
});

export function addRoutes(routes: any) {
  router.addRoute(routes);
}

export default router;
